/*
 * Decompiled with CFR 0.152.
 */
package com.james.tinkerscalibration.modifiers;

import javax.annotation.Nullable;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.phys.EntityHitResult;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.hook.combat.MeleeHitModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.ranged.ProjectileHitModifierHook;
import slimeknights.tconstruct.library.module.ModuleHookMap;
import slimeknights.tconstruct.library.tools.context.ToolAttackContext;
import slimeknights.tconstruct.library.tools.helper.ToolDamageUtil;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ModifierNBT;
import slimeknights.tconstruct.library.tools.nbt.NamespacedNBT;

public class LevitateModifier
extends Modifier
implements MeleeHitModifierHook,
ProjectileHitModifierHook {
    private static MobEffectInstance makeLevitateEffect(int level) {
        return new MobEffectInstance(MobEffects.f_19620_, 60 * level, level - 1);
    }

    protected void registerHooks(ModuleHookMap.Builder hookBuilder) {
        hookBuilder.addHook((Object)this, ModifierHooks.MELEE_HIT, ModifierHooks.PROJECTILE_HIT);
    }

    public void afterMeleeHit(IToolStackView tool, ModifierEntry modifier, ToolAttackContext context, float damageDealt) {
        if (context.isFullyCharged()) {
            LivingEntity target = context.getLivingTarget();
            LivingEntity attacker = context.getAttacker();
            if (target != null && target.m_6084_()) {
                target.m_7292_(LevitateModifier.makeLevitateEffect(modifier.getLevel()));
                ToolDamageUtil.damageAnimated((IToolStackView)tool, (int)(2 * modifier.getLevel()), (LivingEntity)attacker);
            }
        }
    }

    public boolean onProjectileHitEntity(ModifierNBT modifiers, NamespacedNBT persistentData, ModifierEntry modifier, Projectile projectile, EntityHitResult hit, @Nullable LivingEntity attacker, @Nullable LivingEntity target) {
        AbstractArrow arrow;
        if (target != null && (!(projectile instanceof AbstractArrow) || (arrow = (AbstractArrow)projectile).m_36792_())) {
            target.m_7292_(LevitateModifier.makeLevitateEffect(modifier.getLevel()));
        }
        return false;
    }
}

